<!DOCTYPE html>
<html>
<head>
	<title>Results of the Law of One Relistening Project</title>
	<meta http-equiv="content-type" content="text/html; charset=utf-8">
	<meta name="keywords" content="law of one, infinite creator, logos, service to others, ra, seven densities, two paths, free will, unity">
	<link rel="shortcut icon" href="f1369028838favicon.ico" type="image/x-icon">
	<link rel="apple-touch-icon-precomposed" href="f-1869899766apple-touch-icon.png">
	<link rel="stylesheet" href="f-788052878styles.css" type="text/css">
	<meta name="description" content="A write-up of the findings of the Law of One relistening project. Includes examples of changes, new lines, and new questions and answers.">
</head>
<body>
<a name="top"></a><h1>Results of the <a href="_h_.html"><i>Law of One</i></a> Relistening Project </h1>
<p style="text-align: center;"><a href="#introduction">Introduction</a> • <a href="#most-significant">Most&nbsp;significant&nbsp;changes</a> • <a href="#less-significant">Less&nbsp;significant&nbsp;changes</a> • <a href="#possible">Possible&nbsp;misstatements</a> • <a href="#edited">Edited&nbsp;and&nbsp;unedited answers</a> • <a href="#editorial">Editorial&nbsp;Changes</a> • <a href="#notes">Notes</a> • <a href="#observations">Observations</a> • <a href="#acknowledgments">Acknowledgments</a></p>
<div class="heading-list">
<a name="introduction"></a><h2 style="text-align: left;">Introduction</h2>
<p>The relistening project started in the fall of 2004.  I had put <a href="_h_.html">lawofone.info</a> online with the material from the first four books of <i>The Law of One</i>, and I was interested in adding the material from <i>Book V</i>, the questions and answers of which I wanted to integrate into each session in the order in which they occurred.  It turned out that the only way to find out where that material belonged was to listen to copies of the original tapes.  Once I started listening, I realized that there was information that had never been published before, and I decided that it would be worth editing the transcripts to try to make them as accurate as possible.</p>

<p>I listened to sessions 1–98 in much the way that Jim McCarty, the original scribe, had: by playing tapes on a small portable tape recorder.  In 2006, Gary Bean at L/L&nbsp;Research created digital copies of the original tapes, and in 2007 and 2008 Terry Hsu carefully listened to mp3s of sessions 75–106. Terry eventually decided that, since English is not his native language, he was not the best person for the job, but his infectious enthusiasm carried me through many a dry spell in my relistening efforts.</p>

</p>Eventually, I realized that the digital copies were better than the 
cassette copies I had been using, so I switched to them for sessions 99–106.  
In 2010, I asked L/L if they could arrange for volunteers to verify the 
transcripts I had created, and Gary recruited Eric Lyman for the job.  He began 
with the later sessions and worked his way back to session 31.  Time 
constraints made it impossible for Eric to continue, but we were
quite fortunate, because Michelle Holt picked up the baton, verified 
sessions 1–30, and then worked her way through the later sessions, too.</p>

<p>I wanted to create as accurate a transcription as possible, but I did not want to lose the readability of the original books.  My solution has been to create three versions, which I call Original, Relistened, and Lightly Edited.  It is possible to browse or search this site using any of the three; the “Lightly Edited” is the default.  For more information about the different versions and a way to identify the differences between them, please see the <a href="f-991132332versions.php">versions page</a>.<p>

<p><a href="#top">Back to top</a></p>

<a name="most-significant"></a><h2 style="text-align: left; border-top: 1px solid black; padding-top: 10px;">Most significant changes</h2>
<h3>Dropped lines restored</h3>
<p>One of the most interesting discoveries was that segments of a number of answers were dropped in publication, many possibly due to typesetting errors. In some cases, they clarified what had been puzzling answers from Ra. Here is a list:</p>
<h4>Complete list of restored lines:</h4>
<ul>
<li><a href="f2063015009show-diff.php">1.0</a> …You are part of a thought. You are dancing in a ballroom in which there is no material. You are dancing thoughts.</li>
<li><a href="f2063015009show-diff.php">1.1</a> …We, too, have our place. We are not those of the Love or of the Light.</li>
<li><a href="f2063015009show-diff.php">1.1</a> …This is not so with many of the entities of the Confederation. We found it was not efficacious.</li>
<li><a href="f-1457455973show-diff.php">7.12</a> …Some of these landings are of your peoples…</li>
<li><a href="f-1402902689show-diff.php">12.9</a> …Other sightings are due to the inadvertent visualization by your peoples’ optical mechanisms of your own government’s weaponry.</li>
<li><a href="f-1144737251show-diff.php">14.10</a> …a premature aging process. We were attempting to aid in giving the mind/body/spirit complexes of third density…</li>
<li><a href="f-1015654532show-diff.php">15.14</a> …always stating the prerequisite of meditation, contemplation…</li>
<li><a href="f-886571813show-diff.php">16.27</a> …The free will of your future is not making this available. We shall speak on one item. There is a fairly large percentage, approximately thirty-five percent of the intelligent planets, which do not fit in the percentiles. These mysteries are of sixth and seventh density and are not available for our speaking.</li>
<li><a href="f-628406375show-diff.php">18.1</a> …The errors which have occurred have occurred due to the occasional variation in the vibrational complex of this instrument due to its ingestion of a chemical substance.</li>
<li><a href="f-1954471134show-diff.php">20.45</a> Go forth, therefore, rejoicing in the power and the peace of the One Creator.</li>
<li><a href="f-1050892101show-diff.php">27.1</a> …at what you would call a later period in your time measurement.</li>
<li><a href="f-792726663show-diff.php">29.32</a> Does this fulfill the requirements of your query?</li>
<li><a href="f-2118791422show-diff.php">31.5</a> …The green-ray energy transfer occurs due to the vibratory rate of…</li>
<li><a href="f-1989708703show-diff.php">32.1</a> …entity to radiate to the other-…</li>
<li><a href="f2070463167show-diff.php">67.11</a> …service. You will find an infinite array of contradictory requests for…</li>
<li><a href="f1389812003show-diff.php">74.8</a> …A great deal of the answer you seek is in this sentence.</li>
<li><a href="f838243558show-diff.php">82.10</a> …This is for the purpose of refinement of the one original thought.</li>
<li><a href="f1354574434show-diff.php">86.18</a> …loss to the conscious mind of the…</li>
<li><a href="f415757832show-diff.php">91.24</a> …flight, and messages, and movement, and in some cases, protection. The folded wing in this image is intended to suggest… </li>
<li><a href="f932088708show-diff.php">95.4</a> …vibrations. We suggest that you then request of this living entity that it now be welcoming and absorbent for the…</li>
</ul>

<a name="new-questions-and-answers"></a><h3>New questions and answers</h3>
<p>There were also a number of questions and answers that had never been published before, not even in <i>Book V</i>.  The most interesting ones: the benefits of service to others in maintaining youthful appearance <a href="f-1015654532show-diff.php">(15.6</a>), confederation aid in 2D to 3D harvest <a href="f-499323656show-diff.php">(19.7</a>), sex life of the cat Gandalf <a href="f2047093155show-diff.php">(30.13</a>), answers to unasked questions can’t be published <a href="f2011855586show-diff.php">(42.1</a>), and the effects of a pyramid built of rods <a href="f-1802018403show-diff.php">(58.16</a>). In addition, several new paragraphs in regards to healing and Carla’s energy center balance were added to an answer from session 12 <a href="f-1402902689show-diff.php">(12.31</a>).</p>

<p>Others: Orion <a href="f-886571813show-diff.php">contacts</a> and <a href="f-886571813show-diff.php">techniques</a>, <a href="f-886571813show-diff.php">cattle mutilations</a>, <a href="f-1825388415show-diff.php">Maldek</a>, <a href="f-1825388415show-diff.php">Lemuria</a>, <a href="f-1567222977show-diff.php">“thank</a> <a href="f2035225598show-diff.php">you’s”</a>, <a href="f-1438140258show-diff.php">coughing</a> <a href="f-1179974820show-diff.php">requests</a>, <a href="f2047093155show-diff.php">dinosaur extinction</a>, <a href="f-1766780834show-diff.php">maintenance</a> <a href="f-1966338691show-diff.php">questions</a>, <a href="f-1508615396show-diff.php">not-answered questions</a>, <a href="f1260729284show-diff.php">corrections</a>, <a href="f-1966338691show-diff.php">Esmerelda Sweetwater</a>, <a href="f1131646565show-diff.php">sexual energy transfer</a>, <a href="f1906142879show-diff.php">galactic evolution</a>, <a href="f-1143528351show-diff.php">the Billy Meier contact</a>, and a <a href="f967326277show-diff.php">simulator analogy to pre-veil existence</a>.</p>
<h4>Complete list of new questions and answers:</h4>
<ul>
<li><a href="f2063015009show-diff.php">1.5</a> (inaudible)</li>
<!-- tweak link anchor after regenerating diff --><li><a href="f-1457455973show-diff.php">7.13</a> (Orion/our own UFOs)</li>
<li><a href="f-1402902689show-diff.php">12.31</a> — not completely new, but several new paragraphs about Carla in question about wanderers healing themselves</li>
<li><a href="f-1273819970show-diff.php">13.27</a> (visitor to evening session)</li>
<li><a href="f-1015654532show-diff.php">15.6</a> (youthful appearance)</li>
<li><a href="f-886571813show-diff.php">16.13–16.14</a> (Orion contacts); <a href="f-886571813show-diff.php">16.43–16.46</a> (cattle mutilations); <a href="f-886571813show-diff.php">16.58</a> (Orion techniques)</li>
<li><a href="f-499323656show-diff.php">19.7</a> (Confederation aid in 2D/3D harvest)</li>
<li><a href="f-1825388415show-diff.php">21.5–21.7</a> (Maldek); <a href="f-1825388415show-diff.php">21.21–21.23</a> (history of Orion contacts); <a href="f-1825388415show-diff.php">21.24–21.27</a> (Lemuria)</li>
<li><a href="f-1567222977show-diff.php">23.18</a> (Just “Thank you.”)</li>
<li><a href="f-1438140258show-diff.php">24.2–24.3</a>, <a href="f-1438140258show-diff.php">24.5</a>, <a href="f-1438140258show-diff.php">24.7</a>, <a href="f-1438140258show-diff.php">24.15</a>, <a href="f-1438140258show-diff.php">24.21</a>, <a href="f-1438140258show-diff.php">24.22</a> (Coughing requests, for the most part)</li>
<li><a href="f-1179974820show-diff.php">26.9</a>, <a href="f-1179974820show-diff.php">26.14</a>, <a href="f-1179974820show-diff.php">26.29</a>, <a href="f-1179974820show-diff.php">26.35</a>, <a href="f-1179974820show-diff.php">26.37</a>, <a href="f-1179974820show-diff.php">26.39</a> (coughing requests)</li>
<li><a href="f-921809382show-diff.php">28.12</a>, <a href="f-921809382show-diff.php">28.17</a> (Coughing requests)</li>
<li><a href="f2047093155show-diff.php">30.8</a> (dinosaur extinction), <a href="f2047093155show-diff.php">30.13</a> (spiritual side of the cat Gandalf’s sex life)</li>
<li><a href="f-2118791422show-diff.php">31.1</a> (instrument’s condition)</li>
<li><a href="f1882772867show-diff.php">41.3</a> (will moving affect Ra contact?)</li>
<li><a href="f2011855586show-diff.php">42.1–42.2</a> (difference between mentally requested and spoken questions; lengthy question about balancing), <a href="f2011855586show-diff.php"><!-- edited question, don’t count as new in update queries -->42.21</a> (cattle mutilations)</li>
<li><a href="f-1766780834show-diff.php">46.1</a> (instrument’s condition), <a href="f-1766780834show-diff.php">46.6</a> (whether to end session)</li>
<li><a href="f-1508615396show-diff.php">48.4</a> (what would Ra do if incarnate now)</li>
<li><a href="f1460287141show-diff.php">50.10</a> (metal bending wearing pyramid hats)</li>
<li><a href="f1976618017show-diff.php">54.1</a> (instrument’s condition), <a href="f1976618017show-diff.php">54.20</a> (programming catalyst)</li>
<li><a href="f-1802018403show-diff.php">58.16</a> (rod-sided pyramid vs. solid-sided)</li>
<li><a href="f1166884134show-diff.php">60.1</a> (instrument’s condition)</li>
<li><a href="f1683215010show-diff.php">64.3</a> (number of wanderers)</li>
<li><a href="f-1966338691show-diff.php">69.1–69.2</a> (instrument’s condition), <a href="f-1966338691show-diff.php">69.20–69.21</a> (Esmerelda Sweetwater)</li>
<li><a href="f1131646565show-diff.php">72.16</a> (sexual energy transfer)</li>
<li><a href="f1260729284show-diff.php">73.15</a> (correction about miracles infringing on free will)</li>
<li><a href="f1906142879show-diff.php">78.14</a> (galactic evolution)</li>
<li><a href="f2035225598show-diff.php">79.3</a> (sexual energy transfer)</li>
<li><a href="f2035225598show-diff.php">79.44</a> (Thank you)</li>
<li><a href="f967326277show-diff.php">83.8</a> (analogy of flying in a simulator to life pre-veil)</li>
<li><a href="f803005989show-diff.php">94.17</a> (Clarification)</li>
<li><a href="f-1143528351show-diff.php">100.4–100.5</a> (Billy Meier contact)</li>
</ul>

<p><a href="#top">Back to top</a></p>

<a name="less-significant"></a><h2 style="text-align: left; border-top: 1px solid black; padding-top: 10px;">Less significant changes</h2>
<p>There were many tweaks to Ra’s answers and many, many changes to Don’s questions.  A few examples are shown below (original version first).  To see all the changes, browse through the <a href="f2063015009show-diff.php">original/edited&nbsp;difference&nbsp;pages</a>. To see only the changes to Ra’s answers, use the <a href="f-1701826278show-diff.php">answers&nbsp;only&nbsp;pages</a>.</p>

<h4><a href="f-1973786849show-diff.php">3.11</a></h4>
<p>The pyramids which we thought/built were constructed thought-forms created by our social memory complex.<br>
The pyramids which we thought/built were constructed <b>from</b> thought-forms created by our social memory complex.</p>

<h4><a href="f-1844704130show-diff.php">4.9</a></h4>
<p>…thus bringing with them in totally latent form many skills and understandings…<br>
…thus bringing with them in <b>sometimes</b> totally latent form many skills and understandings…</p>

<h4><a href="f-1661068127show-diff.php">10.14</a></h4>
<p>The exercise is to consciously <b>see</b> that love in awareness and understanding distortions.<br>
The exercise is to consciously <b>seek</b> that love in awareness and understanding distortions.</p>

<h4><a href="f1718452579show-diff.php">52.9</a></h4>
<p>to recapitulate a learning/teaching which is adjudged to be less than <b>perfect</b>.<br>
to recapitulate a learning/teaching which is adjudged to be less than <b>perfectly balanced</b>.</p>

<h4><a href="f1260729284show-diff.php">73.22</a></h4>
<p>Firstly, that exercise of which we have spoken called the exercise of fire: this is, <b>through</b> physical energy transfer, not that which is deeply involved in the body complex combinations.<br>
Firstly, that exercise of which we have spoken called the exercise of fire: this is, <b>though</b> physical energy transfer, not that which is deeply involved in the body complex combinations.</p>

<h4><a href="f1741822591show-diff.php">89.19</a></h4>
<p>…intended to be studied as individual concept <b>complexes</b> as Matrix, Potentiator, etc., in viewing mind/body/spirit connections and in pairs with…<br>
…intended to be studied as individual concept <b>complexes;</b> as Matrix, Potentiator, etc. in viewing mind/body/spirit connections<b>;</b> and in pairs with</p>

<h4><a href="f-756280194show-diff.php">103.4</a></h4>
<p>…that is, to put value in a fatal action and die or to put value on consciousness of the creation of the One Creator and, thereby, live.<br>
…that is, to put value in a fatal action and die or to put value on consciousness of the creation <b>and</b> of the One Creator and, thereby, live.</p>

<h4>Unediting questions sometimes made Ra’s answers clearer. Example:<br>
<a href="f-1143528338show-diff.php">100.10</a></h4>
<p>Questioner: The crown of three stars, we are guessing, <b>would represent the balancing</b> of the mind, body, and spirit. Is this in any way correct?<br>
Questioner: The crown of three stars, we are guessing, <b>indicates mastery and balancing</b> of the mind, body, and spirit. Is this in any way correct?<br>
Ra: I am Ra. This device is astrological in origin and the interpretation given somewhat confusing.</p>

<h4>Sometimes answers became less clear, for example:<br>
<a href="f-1531985408show-diff.php">11.7</a></h4>
<p>The mind/body/spirit complex known <b>as</b> Adolf<br>
The mind/body/spirit complex known Adolf</p>

<h4><a href="f-886571813show-diff.php">16.54</a></h4>
<p>If it is <b>a</b> contemplative general daydream…<br>
If it is contemplative general daydream…</p>

<p><a href="#top">Back to top</a></p>

<a name="possible"></a><h2 style="text-align: left; border-top: 1px solid black; padding-top: 10px;">Possible misstatements</h2>

<p>There are a few answers where Ra may have misspoken.  It’s hard to know for sure because Don didn’t follow up on these; however, they were changed in the originally published books.  Previously published versions shown first; actual transcripts second.</p>

<h4><a href="f-1473377827show-diff.php">36.12</a></h4>
<p>There are no <b>negative</b> beings which have attained the Oversoul manifestation…<br>
There are no beings which have attained the Oversoul manifestation…</p>

<h4><a href="f-1508615396show-diff.php">48.2</a></h4>
<p>…common to a reasonable number of entities who, having lost the desire for orange- and <b>yellow</b>-ray sexual experiences…<br>
…common to a reasonable number of entities who, having lost the desire for orange- and <b>green</b>-ray sexual experiences…</p>

<h4><a href="f1906142879show-diff.php">78.29</a></h4>
<p>You may see the air and <b>fire</b> of that which is chaos as literally illuminating and forming the formless<br>
You may see the air and <b>water</b> of that which is chaos as literally illuminating and forming the formless</p>

<a name="edited"></a><h2 style="text-align: left; border-top: 1px solid black; padding-top: 10px;">Edited and unedited answers</h2>

<h3>Edited answers</h3>
<p style="margin-bottom: 0px;">For the most part, the “Edited Version,” which is the default version on this site, uses the answers from the “Relistened Version.”  The exceptions include the possible misstatements above and other minor tweaks:</p>
<ul>
<li><a href="f-2102866685show-diff.php">2.2</a> …already closely aligned with <b>a[n] all-embracing</b> belief in the live-ness or consciousness of all.</li>
<li><a href="f-1586535809show-diff.php">6.8</a> This Council is located in the octave, or <b>eight[h]</b> dimension, of the planet Saturn…</li>
<li><a href="f-1531982525show-diff.php">11.7</a> The mind/body/spirit complex known <b>[as]</b> Adolf…</li>
<li><a href="f-1531982525show-diff.php">11.17</a> The … memory … then <b>become[s]</b> known to the social complex…</li>
<li><a href="f-1144734368show-diff.php">14.10</a> The balancing pyramidal structures could <b>[be]</b> and were used for individual initiation.</li>
<li><a href="f-628403492show-diff.php">18.3</a> <s>tape blank</s> LSD</li>
<li><a href="f-499320773show-diff.php">19.1</a> <s>has/is/will experienced/experiences/experiences</s> has/is/will experienced/experiencing/experience</li>
<li><a href="f-1438137375show-diff.php">24.17</a> …the impression that they had given to those who called them <b>[was]</b> that these entities were an elite group…</li>
<li><a href="f2047096038show-diff.php">30.10</a> …this being not only by the functions of energy transfer but also <b>[by]</b> the various services performed…</li>
<li><a href="f-1473377827show-diff.php">36.12</a> There are no <b>[negative]</b> beings which have attained the Oversoul manifestation…</li>
<li><a href="f-1931098239show-diff.php">57.17</a> If those who desired to be healers <b>[were]</b> of a crystallized nature and…</li>
<li><a href="f-1931098239show-diff.php">57.24</a> The initiation of <b>[the]</b> Queen’s Chamber has to do with the abandoning of self…</li>
<li><a href="f1166887017show-diff.php">60.17</a> …those things most holy… <b>[were]</b> placed.</li>
<li><a href="f1906145762show-diff.php">78.19</a> <s>Logois</s> Logoi</li>
<li><a href="f1354577317show-diff.php">86.12</a> However, in that mystic or prophet <b>[who]</b> desires to serve, such service will increase the entity’s polarity.</li>
<li><a href="f1354577317show-diff.php">86.18</a> <s>The loss to the conscious mind of</s></li>
<li><a href="f1741825474show-diff.php">89.44</a> the more carefully polarized of negative <b>mind/body/spirits*</b></li>
<li><a href="f286677996show-diff.php">90.23</a> <b>mind/body/spirits*</b> undergoing Its care</li>
<li><a href="f544843434show-diff.php">92.17</a> <s>D— Due</s> Due to the first misperception</li>
<li><a href="f803008872show-diff.php">94.9</a> …<b>this entity</b>… <b>[has]</b> done substantial work … and <b>[has]</b> indeed developed maturity and rationality.</li>
<li><a href="f932091591show-diff.php">95.27</a> <b>Each</b> of the images … <b>[has]</b> the increasing intensity…</li>
</ul>

<h3>Answers that could be edited but aren’t currently</h3>
<p style="margin-bottom: 0px;">These answers were edited in the books published by L/L Research.  However, they are shown in the “Edited” and “Relistened” versions as they were recorded in the audio:</p>
<ul>
<li><a href="f2063015009show-diff.php">1.9</a> …in which case you have done <b>you/they</b> little or no good.</li>
<li><a href="f-1973786849show-diff.php">3.4</a> Please <b>check your eye</b> to make fine correction.</li>
<li><a href="f-1844704130show-diff.php">4.20</a> One item which may be of interest is that a healer asking to learn must take the distortion understood as responsibility for that ask/receiving, <b>thus healing</b>.</li>
<li><a href="f-1844704130show-diff.php">4.20</a> This is <b>a honor/duty</b>…</li>
<li><a href="f-792726663show-diff.php">29.33</a> This entity has <b>a experiential history</b> of healing</li>
<li><a href="f-2060183841show-diff.php">56.7</a> …as it passes through <b>the Queen Chamber</b> position…</li>
<li><a href="f1225491715show-diff.php">85.16</a> moves ever more <b>fairly</b> into the green ray.</li>
</ul>

<p><a href="#top">Back to top</a></p>

<a name="editorial"></a><h2 style="text-align: left; border-top: 1px solid black; padding-top: 10px;">Editorial Changes</h2>
<p>In the course of creating and editing the relistened version, I made some changes to paragraphing, spelling, etc.</p>

<h3>Paragraphing changes</h3>
<ul>
<li><a href="f-1637698115show-diff.php">47.15</a></li>
<li><a href="f1718452579show-diff.php">52.2</a></li>
<li><a href="f2105700736show-diff.php">55.18</a></li>
<li><a href="f-592323336show-diff.php">63.9</a></li>
<li><a href="f1812297729show-diff.php">65.23</a></li>
</ul>

<h3>Spelling changes</h3>
<ul>
<li>affect(ed)/effect(ed) (<a href="f-1973786849show-diff.php">3.1</a>, <a href="f-1586538692show-diff.php">6.1</a>, <a href="f1061171427show-diff.php">96.2</a>, <a href="f1061171427show-diff.php">96.3</a>, <a href="f1190254146show-diff.php">97.10</a>)</li>
<li>lightening/lightning (<a href="f-757489094show-diff.php">17.27</a>)</li>
<li>principles/principals (<a href="f-1086129670show-diff.php">39.9</a>)</li>
<li>dynaflagallate/dinoflagellate (<a href="f1882772867show-diff.php">41.10</a>, <a href="f1882772867show-diff.php">41.11</a>, <a href="f1882772867show-diff.php">41.13</a>)</li>
<li>effect/affect (<a href="f-1508615396show-diff.php">48.2</a>, <a href="f-1379532677show-diff.php">49.8</a>)</li>
<li>naval/navel (<a href="f-1931101122show-diff.php">57.10</a>, <a href="f-1931101122show-diff.php">57.11</a>)</li>
<li>its self/itself (<a href="f1166884134show-diff.php">60.3</a>, <a href="f1131646565show-diff.php">72.15</a>, <a href="f1389812003show-diff.php">74.11</a>, <a href="f1777060160show-diff.php">77.6</a>)</li>
<li>in so far/insofar (<a href="f1131646565show-diff.php"><a href="f1131646565show-diff.php">72.8</a></a>, <a href="f-369032037show-diff.php">106.23</a>)</li>
<li>your self/yourself (<a href="f1389812003show-diff.php">74.11</a>, <a href="f1225491715show-diff.php">85.4</a>)</li>
<li>one’s self/oneself (<a href="f286675113show-diff.php">90.9</a>)</li>
<li>accouterments/accoutrements (<a href="f803005989show-diff.php">94.30</a>)</li>
<li>waved/waived (<a href="f1061171427show-diff.php">96.13</a>)</li>
<li>Added accents to words that Ra pronounced with two syllables: wingèd (<a href="f415757832show-diff.php">91.24</a>, <a href="f673923270show-diff.php">93.10</a>, <a href="f1190254146show-diff.php">97.5</a>, <a href="f1190254146show-diff.php">97.7</a>), blessèd (<a href="f-369032037show-diff.php">106.7</a>), markèd (<a href="f2070463167show-diff.php">67.21</a>, <a href="f-369032037show-diff.php">106.12</a>).</li>
<li>Added accents to séance, naïveté, naïve.</li>
</ul>

<h3>Hyphenation changes</h3>
<ul>
<li>being-ness → beingness</li>
<li>rock-ness → rockness</li>
<li>third density entity → third-density entity</li>
<li>in third-density → in third density</li>
<li>green ray transfer → green-ray transfer</li>
<li>the green-ray is → the green ray is</li>
<li>the path of service-to-others → the path of service to others</li>
<li>the service to others path → the service-to-others path</li>
<li>the path of service-to-self → the path of service to self</li>
<li>the service to self path → the service-to-self path</li>
<li>true color green → true-color green</li>
<li>requestion → re-question</li>
<li>over-ride → override</li>
</ul>

<h3>Capitalization changes</h3>
<ul>
<li><a href="f1589369860show-diff.php">51.6</a> Secrets Of The Great Pyramid → Secrets of the Great Pyramid</li>
<li><a href="f1847535298show-diff.php">53.24</a> THE LAW OF ONE → The Law of One</li>
<li><a href="f2105700736show-diff.php">55.14</a> The Life Force Of The Great Pyramid → The Life Force in the Great Pyramid</li>
</ul>

<p><a href="#top">Back to top</a></p>

<a name="notes"></a><h2 style="text-align: left; border-top: 1px solid black; padding-top: 10px;">Notes</h2>
<ul>
<li><a href="f-85315607show-diff.php">Session 26</a>.  In <i>Book I</i>, session 26 included a number of questions that were actually from session 53.  Those questions have been removed from the versions of session 26 shown at this site. Also, a question about sexual energy transfer that was actually asked during this session, <a href="f-1179974820show-diff.php">26.38</a>, was not published until <i>Book II</i> (originally published as <a href="f-2118791422show-diff.php">31.1</a>).</li>
<li><a href="f1460287141show-diff.php">Session 50</a>.  In <i>Book II</i>, session 50 was published somewhat out of order.  (The poker analogy was not really at the end of the session.)  It is shown in the order in which it was recorded in the the “Edited”  and “Relistened” versions.</li>
<li><a href="f1518894722show-diff.php">Session 75</a> was also originally published out of order and has also been restored.</li>
<li>There were four sessions in which Don asked Ra to cause Carla’s body to cough: <a href="f-1438140258show-diff.php">24</a>, <a href="f-1179974820show-diff.php">26</a>, <a href="f-921809382show-diff.php">28</a>, <a href="f1190254146show-diff.php">97</a> (97 was already marked as such).</li>
<li>In the original books, individual’s names were shown as “(name).”  For the most part we have continued to leave names out, except where the individuals mentioned gave permission or have since passed away. Jim and Carla have given permission to use their names and Don’s wherever they occurred, and we have also included the names of two well-known UFO contactees that Ra was asked about: <a href="f-118685258results.php">Betty Andreasson</a> and <a href="f615720409results.php">Billy Meier</a>.</li>
<li>Optional notes.  The originally published books contained footnotes with definitions of unusual words, etc.  Those have been included in all the versions but hidden by default. To see them, click “<a href="f1935608700relistening-report.php">See notes</a>.”<span class="optional">*</span></li>
<div class="optional">
	<hr align="left" style="width: 100px;">
	<p>* Notes are now visible. <a href="f1935608699relistening-report.php">Hide them</a>.</p>
</div>
<!-- li>Relistening footnotes.  The relistened version indicates blank spots in the audio with [brackets] and includes optional footnotes that explain the reasons for the blank spots (tape flips, etc.)  To see them, click “see footnotes.”</li -->
<li>Corrections.  When Ra or Don noticed that incorrect information had been given, they corrected that information.  In the originally published books, the incorrect questions or answers were edited.  In the “Edited” and “Relistened” versions, the incorrect information is shown as recorded, but the correct information is noted below it.</li>
</ul>

<p><a href="#top">Back to top</a></p>

<a name="observations"></a><h2 style="text-align: left; border-top: 1px solid black; padding-top: 10px;">Observations</h2>
<p style="margin-bottom: 0px;">This project has deepened and enriched the already profound respect I had for the individuals involved and for those of Ra.  I was previously aware that Don, Carla, and Jim had made significant sacrifices in order to put themselves in a position to channel Ra.  Listening to the sessions made real to me that the sacrifices were ongoing and the commitment on all parts quite unequivocal.  It increased my respect for all involved:</p>
<ul>
<li>for Carla, because the toll it took on her was quite apparent in the sound of her voice when she returned to her body after each session, and because of her incredible accuracy as a channel in session one, which was not in trance but reads very nearly the same as the other sessions, when she was;</li>
<li>for Don because of his ability to stay tuned into Ra’s lengthy and uninflected answers and follow up with intelligent and focused questions, and for the love and concern for Carla and respect and friendship for Jim that he showed throughout the sessions;</li>
<li>for Jim for the quiet power that he demonstrated during the times it was necessary to re-walk the Circle of One and in flipping the tapes (really!) and for the accuracy of his original transcriptions;</li>
<li>for Ra — their faithfulness in answering, as precisely and completely as possible whatever was asked of them, even though it was apparent, from the tone of voice they sometimes used, for example in their answers to questions about the archetypical mind, that they did actually have significant preferences as to the type of information they wanted to share.</li>
</ul>

<p>Some of the most poignant moments in the sessions occur at the end of each session.  After Ra had given their final statement, Don would call Carla back to her body by quietly and persistently saying his nickname for her, “Alrac” (Carla backwards).  “Alrac…” “Alrac…” “Alrac…”  Sometimes it took quite a while before Carla replied.  “Yeah?” she’d say, and then Don would ask, “How do you feel?”  Often the audio ended at that point, but sometimes you’d hear Carla’s response: “OK,” or “Tired,” or “Mmmph.”  Often her voice sounded incredibly weary.</p>

<p>I had always wondered how Don could speak with no false starts. In fact, he did false start, but not too often. Sometimes, Ra picked up on parts of his questions that were later edited out. Example: <a href="f1612739872show-diff.php">88.17</a> (“condense the archetypes”).  Don was remarkably good at telling when Ra was done with an answer, but occasionally they would start talking at the same time.  Other times Ra would wait patiently until Don realized that he had only made a statement, not asked a question, and appended “Is that correct?” or something similar to his statement.  Several times it’s possible to hear Don chuckling or reacting, such as after Ra answered a complicated question in one word (“No.”) (<a href="f-731035844results.php">65.18</a>)</p>

<p>In general, there was very little background noise, the amazing exception being <a href="f-788294159results.php">session 45</a>, when water truckers attempted to make a delivery.  Other exceptions: a <a href="f-998402434results.php">phone ringing</a> in session 1; Jim <a href="f-998402434results.php">unloading groceries</a> in session 1, occasional cat purrs and meows.</p>

<p>Ra spoke &nbsp; q u i t e &nbsp; s l o w l y &nbsp; and in a mostly monotone voice except when they discussed the archetypes, when their enthusiasm came through.  In the first session, as mentioned above, Carla was not in trance, and there her intonations sound like we expect ”normal” spoken conversation to sound.  Some of the other sessions are especially monotone; it seems to have to do with how deeply in trance Carla was.  The first session is the only time you hear the opening “I am Ra,” because in all other sessions Don and Jim waited until Ra began speaking before they began recording.</p>

<p>After the first session, L/L recorded each session on three cassettes, which they staggered so as not to lose any information.  Sessions 1–17 are fairly faint, especially the questions, but the quality of the rest of the recordings is relatively good.  In each session, after about 45 minutes, one can hear the sound of a cassette tape stopping and being flipped and restarted.  Unfortunately, L/L only saved one tape from each session, meaning that the material at the tape flips cannot be verified.  Also unfortunately, the back side of session one was used to record a different meditation and thereby lost.</p>

<p>In conclusion, I think that it’s been worth it.  The original purpose was to reintegrate the <i>Book V</i> material into each session, and I think that reading the sessions with <i>Book V</i> material restored does indeed add to the experience.  In many ways, the <i>Book V</i> material is the heart of the Ra contact, and it’s nice to be able to read it in context.  In addition, the new material, not previously published anywhere, is interesting to read and in some cases quite valuable.  Finally, the model of dedicated service exemplified in the sessions by Carla, Don, Jim, and Ra has been an inspiration to me personally.</p>

<a name="acknowledgments"></a><h2 style="text-align: left; border-top: 1px solid black; padding-top: 10px;">Acknowledgments</h2>

<p>Many thanks to Don Elkins, for his lifelong quest to learn, to understand, and to
pursue his learning wherever it took him.  The Ra contact was the culmination of a life
of seeking.  Thanks to Carla Rueckert, fearless channel, who put her life and her soul’s
freedom on the line to bring this information through the veil, and to Jim McCarty, the
engine who made it all go.  And thanks to Ra for their light, their precision and power
with words, and their faith that we humans are worth the investment.</p>

<p>Much appreciation, also, to Gary Bean, admin at L/L Research, who provided the initial
batch of tapes to get this project started and who has responded to my every request
with humor and grace; to Terry Hsu of Taipei, Taiwan, who provided unflagging
encouragement (and occasional well-timed reminders) that greatly helped me to
renew and maintain my commitment to this project; to Eric Lyman, who faithfully and persistently
re-relistened to sessions 31–106, catching many discrepancies between my transcripts and
the actual recordings; and to Michelle Holt, who has taken over the re-relistening with great gusto 
and diligence.  I could not have completed this project without any of them.</p>

<p>Finally, all thanks to my beloved wife, Jennifer, and children, Elijah and Elise, who
have listened, with good humor and sometimes even with interest, to many more quotes
from Ra than any wife or children should ever have to.</p>


<p><a href="#top">Back to top</a></p>

</div>
<p style="text-align: center; margin-top: 2em;">
	<a href="_h_.html">Home</a> ∙ 
	<a href="f731037089search.php">Search</a> ∙ 
	<a href="f-1390545771categories.php">Categories</a> ∙ 
	<a href="f-1574893994sessions.php">Sessions</a> ∙ 
	<a href="f-810092595synopsis.php">Synopsis</a> ∙ 
	<a href="f774683843favorite-quotes.php">Favorite&nbsp;Quotes</a> ∙ 
	<a href="f1285527712unusual-words.php">Unusual&nbsp;Words</a> ∙ 
	<a href="f-545413198relistening-report.php">Relistening Report</a> ∙ 
	<a href="f-2042705306tips-and-tricks.php">Tips and Tricks</a> ∙ 
	<a href="f1060319237results.php">Random&nbsp;Q&nbsp;&amp;&nbsp;A</a> ∙ 
	<a href="f2040867444links.php">Links</a> ∙ 
	<a href="f-920912309excerpts.php">Excerpts</a> ∙ 
	<a href="f-991132332versions.php">Versions</a> ∙ 
	<a href="f2063015009show-diff.php">Differences</a> ∙ 
	<a href="f653172817recent-updates.php">Recent&nbsp;Updates</a> ∙ 
	<a href="f1162575527current-goals.php">Current&nbsp;Goals</a> ∙ 
	<a href="f-1376487557recent-referrers.php">Recent Referrers</a> ∙ 
	<a href="f-504967805recent-searches.php">Recent Searches</a> ∙ 
	<a href="f-2075326040images">Images</a> ∙ 
	<a href="http://www.llresearch.org/">L/L Research</a> ∙ 
	<a href="http://www.bring4th.org/">Bring4th</a> ∙ 
	<a href="f-80480438support.php">Donate</a>
</p>
<p style="text-align: center;">The <i>Law of One</i> books are copyright &copy;1982, 1984, 1998 <a href="http://www.llresearch.org/">L/L Research</a>.  This site copyright &copy;2003&ndash;2013 Tobey Wheelock.</p>
<p style="text-align: center;">Questions? Comments? Email me: tw at law of one dot info.</p>
<script src="js/scripts.js" type="text/javascript"></script>
</body>
</html>
